/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.requirement;

import codersafterdark.reskillable.api.event.CacheInvalidatedEvent;
import codersafterdark.reskillable.api.event.LevelUpEvent;
import codersafterdark.reskillable.api.event.LockUnlockableEvent;
import codersafterdark.reskillable.api.event.UnlockUnlockableEvent;
import codersafterdark.reskillable.api.requirement.AdvancementRequirement;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.SkillRequirement;
import codersafterdark.reskillable.api.requirement.TraitRequirement;
import codersafterdark.reskillable.api.requirement.logic.DoubleRequirement;
import codersafterdark.reskillable.api.requirement.logic.OuterRequirement;
import codersafterdark.reskillable.api.requirement.logic.impl.NOTRequirement;
import codersafterdark.reskillable.network.InvalidateRequirementPacket;
import codersafterdark.reskillable.network.PacketHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RequirementCache {
    private static Set<Class<? extends Requirement>> dirtyCacheTypes = new HashSet<Class<? extends Requirement>>();
    private static Map<SidedUUID, RequirementCache> cacheMap = new HashMap<SidedUUID, RequirementCache>();
    private Map<Class<? extends Requirement>, Map<Requirement, Boolean>> requirementCache = new HashMap<Class<? extends Requirement>, Map<Requirement, Boolean>>();
    private Set<Class<? extends Requirement>> recentlyInvalidated = new HashSet<Class<? extends Requirement>>();
    private boolean valid = true;
    private boolean isRemote;
    private boolean dirtyCache;
    private UUID uuid;

    @Deprecated
    public RequirementCache(@Nonnull EntityPlayer player) {
        this(player.func_110124_au(), player.func_130014_f_().field_72995_K);
        cacheMap.put(new SidedUUID(this.uuid, this.isRemote), this);
    }

    private RequirementCache(UUID uuid, boolean isClientPlayer) {
        this.uuid = uuid;
        this.isRemote = isClientPlayer;
    }

    public static RequirementCache getCache(@Nonnull EntityPlayer player) {
        return RequirementCache.getCache(player.func_110124_au(), player.func_130014_f_().field_72995_K);
    }

    public static RequirementCache getCache(UUID uuid, boolean isRemote) {
        SidedUUID sidedUUID = new SidedUUID(uuid, isRemote);
        if (cacheMap.containsKey(sidedUUID)) {
            return cacheMap.get(sidedUUID);
        }
        RequirementCache cache = new RequirementCache(uuid, isRemote);
        cacheMap.put(sidedUUID, cache);
        return cache;
    }

    public static boolean hasCache(@Nonnull EntityPlayer player) {
        return RequirementCache.hasCache(player.func_110124_au(), player.func_130014_f_().field_72995_K);
    }

    public static boolean hasCache(UUID uuid, boolean isRemote) {
        return cacheMap.containsKey(new SidedUUID(uuid, isRemote));
    }

    public static void registerDirtyTypes() {
        RequirementCache.registerRequirementType(NOTRequirement.class, DoubleRequirement.class);
    }

    public static void registerRequirementType(Class<? extends Requirement> ... requirementClasses) {
        dirtyCacheTypes.addAll(Arrays.asList(requirementClasses));
    }

    public static void invalidateCache(EntityPlayer player, Class<? extends Requirement> ... cacheTypes) {
        if (player != null) {
            RequirementCache.invalidateCache(player.func_110124_au(), cacheTypes);
        }
    }

    public static void invalidateCache(UUID uuid, Class<? extends Requirement> ... cacheTypes) {
        boolean hasServer = RequirementCache.hasCache(uuid, false);
        boolean hasClient = RequirementCache.hasCache(uuid, true);
        if (hasServer) {
            EntityPlayer player;
            RequirementCache cache;
            RequirementCache.invalidateCacheNoPacket(uuid, false, cacheTypes);
            if (!hasClient && (cache = RequirementCache.getCache(uuid, false)) != null && (player = cache.getPlayer()) != null) {
                PacketHandler.INSTANCE.sendTo((IMessage)new InvalidateRequirementPacket(uuid, cacheTypes), (EntityPlayerMP)player);
            }
        }
        if (hasClient) {
            RequirementCache.invalidateCacheNoPacket(uuid, true, cacheTypes);
            if (!hasServer) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new InvalidateRequirementPacket(uuid, cacheTypes));
            }
        }
    }

    @Deprecated
    public static void invalidateCacheNoPacket(UUID uuid, Class<? extends Requirement> ... cacheTypes) {
        RequirementCache.invalidateCacheNoPacket(uuid, true, cacheTypes);
        RequirementCache.invalidateCacheNoPacket(uuid, false, cacheTypes);
    }

    public static void invalidateCacheNoPacket(UUID uuid, boolean isRemote, Class<? extends Requirement> ... cacheTypes) {
        RequirementCache.getCache(uuid, isRemote).invalidateCache(cacheTypes);
    }

    public static boolean requirementAchieved(EntityPlayer player, Requirement requirement) {
        return player != null && RequirementCache.requirementAchieved(player.func_110124_au(), player.func_130014_f_().field_72995_K, requirement);
    }

    @Deprecated
    public static boolean requirementAchieved(UUID uuid, Requirement requirement) {
        return RequirementCache.requirementAchieved(uuid, true, requirement) || RequirementCache.requirementAchieved(uuid, false, requirement);
    }

    public static boolean requirementAchieved(UUID uuid, boolean isRemote, Requirement requirement) {
        return RequirementCache.getCache(uuid, isRemote).requirementAchieved(requirement);
    }

    @SubscribeEvent
    public static void onLevelChange(LevelUpEvent.Post event) {
        RequirementCache.invalidateCache(event.getEntityPlayer().func_110124_au(), SkillRequirement.class);
    }

    @SubscribeEvent
    public static void onUnlockableLocked(LockUnlockableEvent.Post event) {
        RequirementCache.invalidateCache(event.getEntityPlayer().func_110124_au(), TraitRequirement.class);
    }

    @SubscribeEvent
    public static void onUnlockableUnlocked(UnlockUnlockableEvent.Post event) {
        RequirementCache.invalidateCache(event.getEntityPlayer().func_110124_au(), TraitRequirement.class);
    }

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        RequirementCache.invalidateCache(event.getEntityPlayer().func_110124_au(), AdvancementRequirement.class);
    }

    @SubscribeEvent
    public static void onDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        RequirementCache.removeCache(event.player.func_110124_au(), true);
        RequirementCache.removeCache(event.player.func_110124_au(), false);
    }

    public static void removeCache(EntityPlayer player) {
        RequirementCache.removeCache(player.func_110124_au(), player.func_130014_f_().field_72995_K);
    }

    public static void removeCache(UUID uuid, boolean isRemote) {
        SidedUUID sidedUUID = new SidedUUID(uuid, isRemote);
        if (cacheMap.containsKey(sidedUUID)) {
            RequirementCache.cacheMap.get((Object)sidedUUID).valid = false;
            cacheMap.remove(sidedUUID);
        }
    }

    @Nullable
    private EntityPlayer getPlayer() {
        if (this.isRemote) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            return world == null ? null : world.func_152378_a(this.uuid);
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            for (WorldServer world : server.field_71305_c) {
                EntityPlayer player = world.func_152378_a(this.uuid);
                if (player == null) continue;
                return player;
            }
        }
        return null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void forceClear() {
        EntityPlayer player;
        if (this.isValid() && (player = this.getPlayer()) != null) {
            this.requirementCache.clear();
            this.recentlyInvalidated.clear();
            this.dirtyCache = false;
            MinecraftForge.EVENT_BUS.post((Event)new CacheInvalidatedEvent(player, true));
            if (!this.isRemote) {
                PacketHandler.INSTANCE.sendTo((IMessage)new InvalidateRequirementPacket(this.uuid, new Class[0]), (EntityPlayerMP)player);
            }
        }
    }

    public boolean requirementAchieved(Requirement requirement) {
        Map<Requirement, Boolean> cache;
        if (requirement == null || !this.isValid()) {
            return false;
        }
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return false;
        }
        if (!requirement.isCacheable()) {
            return requirement.achievedByPlayer(player);
        }
        Class<?> clazz = requirement.getClass();
        if (this.requirementCache.containsKey(clazz)) {
            cache = this.requirementCache.get(clazz);
            if (cache.containsKey(requirement)) {
                return cache.get(requirement);
            }
        } else {
            cache = new HashMap<Requirement, Boolean>();
            this.requirementCache.put(clazz, cache);
        }
        boolean achieved = requirement.achievedByPlayer(player);
        cache.put(requirement, achieved);
        if (!this.dirtyCache && dirtyCacheTypes.stream().anyMatch(dirtyType -> dirtyType.isInstance(requirement))) {
            this.dirtyCache = true;
        }
        this.recentlyInvalidated.removeAll(this.recentlyInvalidated.stream().filter(type -> type.isInstance(requirement)).collect(Collectors.toList()));
        if (requirement instanceof OuterRequirement) {
            this.recentlyInvalidated.removeAll(((OuterRequirement)((Object)requirement)).getInternalTypes());
        }
        return achieved;
    }

    public void invalidateCache(Class<? extends Requirement> ... cacheType) {
        ArrayList<Class<? extends Requirement>> dirtyTypes;
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        ArrayList<Class<? extends Requirement>> arrayList = dirtyTypes = this.dirtyCache ? new ArrayList<Class<? extends Requirement>>(dirtyCacheTypes) : new ArrayList();
        if (cacheType != null) {
            for (Class<? extends Requirement> type : cacheType) {
                if (this.recentlyInvalidated.contains(type)) continue;
                dirtyTypes.add(type);
                this.recentlyInvalidated.add(type);
            }
            if (dirtyTypes.size() == dirtyCacheTypes.size()) {
                MinecraftForge.EVENT_BUS.post((Event)new CacheInvalidatedEvent(player, false));
                return;
            }
        }
        if (dirtyTypes.isEmpty()) {
            MinecraftForge.EVENT_BUS.post((Event)new CacheInvalidatedEvent(player, false));
            return;
        }
        Set<Class<? extends Requirement>> requirements = this.requirementCache.keySet();
        ArrayList<Class<? extends Requirement>> toRemove = new ArrayList<Class<? extends Requirement>>();
        for (Class<? extends Requirement> requirement2 : requirements) {
            for (Class clazz : dirtyTypes) {
                if (!clazz.isAssignableFrom(requirement2)) continue;
                toRemove.add(requirement2);
            }
        }
        toRemove.forEach(requirement -> this.requirementCache.remove(requirement));
        MinecraftForge.EVENT_BUS.post((Event)new CacheInvalidatedEvent(player, !toRemove.isEmpty()));
    }

    private static class SidedUUID {
        private final UUID uuid;
        private final boolean isRemote;

        private SidedUUID(UUID uuid, boolean isRemote) {
            this.uuid = uuid;
            this.isRemote = isRemote;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SidedUUID) {
                SidedUUID other = (SidedUUID)obj;
                return this.isRemote == other.isRemote && this.uuid.equals(other.uuid);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.isRemote, this.uuid);
        }
    }
}

